/**
* \file: AilAudioSink.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* Audio sink endpoint implementation using AIL
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*          P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <AilAudioSink.h>
#include "AilAudioSinkImpl.h"

namespace adit { namespace bdcl {
using std::string;
using std::unique_ptr;

AilAudioSink::AilAudioSink(IAditAudioSinkCallbacks* inCallbacks, CoreCallbackDealer* inCallbackDealer)
: AditAudioSink(inCallbacks, inCallbackDealer)
{
    impl = move(unique_ptr<AilAudioSinkImpl>(new AilAudioSinkImpl(inCallbacks, inCallbackDealer)));
}

AilAudioSink::~AilAudioSink()
{
    // todo who is deleting impl ptr?
}

void AilAudioSink::setConfigItem(string inKey, string inValue)
{
    impl->setConfigItem(inKey, inValue);
}

bool AilAudioSink::initialize()
{
    return impl->initialize();
}

void AilAudioSink::teardown()
{
    impl->teardown();
}

bool AilAudioSink::playbackStart()
{
    return impl->playbackStart();
}

bool AilAudioSink::playbackStop(bool inFlushBuffer)
{
    return impl->playbackStop(inFlushBuffer);
}

//void AilAudioSink::onAudioDataAvailable(uint8_t *inData, uint32_t inLen)
//{
//    impl->onAudioDataAvailable(inData, inLen);
//}

// todo don't forget mediaDataProcess
// todo don't forget ConfigHandle

} } /* namespace adit { namespace bdcl { */
